def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        item1_pos = positions['item1']  # Assuming item1 is the object we need to manipulate
        room_pos = positions['room']     # Assuming room is the location we need to reference

        # Step 1: Move to the room where the item is located
        print("[Task] Moving to the room...")
        obs, reward, done = move(env, 'current_room', room_pos)
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Pick the item
        print("[Task] Picking up item1...")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to a different location to place the item
        print("[Task] Moving to the placement location...")
        obs, reward, done = move(env, room_pos, 'placement_location')  # Replace with actual placement location
        if done:
            print("[Task] Task ended after moving to the placement location!")
            return

        # Step 4: Place the item down
        print("[Task] Placing down item1...")
        obs, reward, done = place(env, task, target_pos='placement_location')  # Replace with actual placement location
        if done:
            print("[Task] Task ended after placing item1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()