def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'tomato2' and its position is known
        tomato2_pos = positions['tomato2']
        robot_pos = positions['robot']  # Assuming we have a robot position

        # Check if the robot is at the same location as the target object
        if not (robot_pos == tomato2_pos):
            print("[Task] Moving to the location of tomato2...")
            move(env, robot_pos, tomato2_pos)

        # Now attempt to pick the object
        print("[Task] Attempting to pick tomato2...")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)

        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Assuming we need to place the object somewhere after picking
        # Define the target location for placing the object
        place_location = positions['place_location']  # Assuming we have a place location

        # Now attempt to place the object
        print("[Task] Attempting to place tomato2...")
        obs, reward, done = place(env, task, target_pos=place_location)

        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()