def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'item1' and a location 'room1'
        item1_pos = positions['item1']
        room1 = 'room1'

        # Step 1: Move to the location of item1
        print("[Task] Moving to item1's location:", item1_pos)
        obs, reward, done = move(env, room1, item1_pos)
        if done:
            print("[Task] Task ended after moving to item1's location!")
            return

        # Step 2: Pick up item1
        print("[Task] Picking up item1.")
        obs, reward, done = pick(env, 'item1', room1, 'gripper')
        if done:
            print("[Task] Task ended after picking up item1!")
            return

        # Step 3: Move to a new location to place item1
        new_location = 'room2'  # Assuming we want to move to room2
        print("[Task] Moving to new location:", new_location)
        obs, reward, done = move(env, item1_pos, new_location)
        if done:
            print("[Task] Task ended after moving to new location!")
            return

        # Step 4: Place item1 in the new location
        print("[Task] Placing item1 in the new location.")
        obs, reward, done = place(env, 'item1', new_location)
        if done:
            print("[Task] Task ended after placing item1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()