def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1 = 'object_1'  # Replace with actual object name
        object_2 = 'object_2'  # Replace with actual object name

        # Get positions of the objects
        object_1_pos = positions[object_1]
        object_2_pos = positions[object_2]

        # Step 1: Move to the location of object_1
        print(f"[Task] Moving to {object_1} at:", object_1_pos)
        obs, reward, done = move(env, task, current_pos, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick object_1
        print(f"[Task] Picking {object_1}")
        obs, reward, done = pick(env, object_1, object_1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the location of object_2
        print(f"[Task] Moving to {object_2} at:", object_2_pos)
        obs, reward, done = move(env, task, object_1_pos, object_2_pos)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return

        # Step 4: Place object_1 at object_2's location
        print(f"[Task] Placing {object_1} at {object_2}")
        obs, reward, done = place(env, object_1, object_2_pos)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Step 5: Move back to the initial position (if needed)
        print("[Task] Returning to initial position.")
        obs, reward, done = move(env, task, object_2_pos, current_pos)
        if done:
            print("[Task] Task ended after returning to initial position!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()