def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a tomato object to manipulate
        tomato_pos = positions.get('tomato')
        if tomato_pos is None:
            print("[Task] Tomato object not found in the environment.")
            return

        # Step 1: Move to the tomato's position
        print("[Task] Moving to tomato at:", tomato_pos)
        obs, reward, done = move(env, task, from_room='rooma', to_room='roomb')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to tomato!")
            return

        # Step 2: Close the gripper
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task, object_list=['tomato'])
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 3: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, 'tomato', 'roomb', 'gripper')  # Adjust parameters as necessary
        if done:
            print("[Task] Task ended after picking tomato!")
            return

        # Step 4: Move to the disposal location
        disposal_location = 'roomc'  # Define the disposal location
        print("[Task] Moving to disposal location:", disposal_location)
        obs, reward, done = move(env, task, from_room='roomb', to_room=disposal_location)
        if done:
            print("[Task] Task ended after moving to disposal location!")
            return

        # Step 5: Place the tomato in the disposal location
        print("[Task] Placing the tomato.")
        obs, reward, done = place(env, 'tomato', disposal_location)
        if done:
            print("[Task] Task ended after placing tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()