def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' to manipulate
        object_1_pos = positions.get('object_1')
        if object_1_pos is None:
            raise ValueError("Object 'object_1' not found in the environment.")

        # Move to the location of object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, task, obs.robot_position, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Pick up object_1
        print("[Task] Picking up object_1.")
        obs, reward, done = pick(env, 'object_1', object_1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up object_1!")
            return

        # Move to a new location to place object_1
        new_location = positions.get('new_location')
        if new_location is None:
            raise ValueError("New location not found in the environment.")

        print("[Task] Moving to new location at:", new_location)
        obs, reward, done = move(env, task, object_1_pos, new_location)
        if done:
            print("[Task] Task ended after moving to new location!")
            return

        # Place object_1 at the new location
        print("[Task] Placing object_1 at new location.")
        obs, reward, done = place(env, 'object_1', new_location)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()