def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a 'tomato' object and a 'switch' in the environment
        tomato_pos = positions['tomato']
        switch_pos = positions['switch']
        robot_pos = positions['robot']

        # Step 1: Move to the tomato
        print("[Task] Moving to tomato at:", tomato_pos)
        obs, reward, done = move(env, robot_pos, tomato_pos)
        if done:
            print("[Task] Task ended after moving to tomato!")
            return

        # Step 2: Close the gripper to prepare for picking
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 3: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, 'tomato', tomato_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato!")
            return

        # Step 4: Move to the switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, tomato_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 5: Close the gripper if not already closed
        print("[Task] Closing gripper again if necessary.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 6: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, 'switch')
        if done:
            print("[Task] Task ended after pressing switch!")
            return

        # Step 7: Place the tomato back (if needed)
        print("[Task] Placing the tomato back.")
        obs, reward, done = place(env, 'tomato', tomato_pos)
        if done:
            print("[Task] Task ended after placing tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()