def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a dark room and need to turn on the light first
        # Let's say the switch is at a known position
        switch_position = positions['switch']  # Replace with actual switch object key
        robot_position = positions['robot']  # Replace with actual robot object key

        # Move to the switch to turn on the light
        print("[Task] Moving to the switch at:", switch_position)
        obs, reward, done = move(env, robot_position, switch_position)
        if done:
            print("[Task] Task ended while moving to the switch!")
            return

        # Close the gripper to press the switch
        print("[Task] Closing gripper to press the switch.")
        obs, reward, done = close_gripper(env)
        if done:
            print("[Task] Task ended while closing the gripper!")
            return

        # Press the switch to turn on the light
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, 'switch')  # Assuming 'switch' is the switch object
        if done:
            print("[Task] Task ended while pressing the switch!")
            return

        # Now we can pick up the object
        object_position = positions['object']  # Replace with actual object key
        print("[Task] Moving to the object at:", object_position)
        obs, reward, done = move(env, robot_position, object_position)
        if done:
            print("[Task] Task ended while moving to the object!")
            return

        # Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, task, target_pos=object_position)
        if done:
            print("[Task] Task ended while picking the object!")
            return

        # Now we can place the object somewhere
        target_location = positions['target_location']  # Replace with actual target location key
        print("[Task] Moving to the target location at:", target_location)
        obs, reward, done = move(env, object_position, target_location)
        if done:
            print("[Task] Task ended while moving to the target location!")
            return

        # Place the object
        print("[Task] Placing the object.")
        obs, reward, done = place(env, task, target_pos=target_location)
        if done:
            print("[Task] Task ended while placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()