def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball and a room in the environment
        ball_pos = positions['ball']
        room_pos = positions['room']

        # Check if the gripper is closed
        if not obs.gripper_closed:
            print("[Task] Closing gripper...")
            obs, reward, done = close_gripper(env, task)
            if done:
                print("[Task] Task ended after closing gripper!")
                return

        # Move to the room where the ball is located
        print("[Task] Moving to the room...")
        obs, reward, done = move(env, task, from_room=room_pos, to_room=room_pos)
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Pick the ball
        print("[Task] Picking the ball...")
        obs, reward, done = pick(env, task, target_pos=ball_pos)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Place the ball in the room
        print("[Task] Placing the ball in the room...")
        obs, reward, done = place(env, task, target_pos=room_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()