def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' to pick
        object_1_pos = positions['object_1']  # Replace with actual object name
        object_1_loc = 'room_a'  # Replace with actual location

        # Step 1: Move to the location of object_1
        print(f"[Task] Moving to {object_1_loc} to pick up object_1.")
        obs, reward, done = move(env, task, 'current_room', object_1_loc)
        if done:
            print("[Task] Task ended while moving to object_1 location!")
            return

        # Step 2: Pick up object_1
        print(f"[Task] Picking up object_1 at: {object_1_pos}.")
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the drop location (e.g., 'drop_zone')
        drop_zone_loc = 'drop_zone'  # Replace with actual drop zone location
        print(f"[Task] Moving to {drop_zone_loc} to drop object_1.")
        obs, reward, done = move(env, task, object_1_loc, drop_zone_loc)
        if done:
            print("[Task] Task ended while moving to drop zone!")
            return

        # Step 4: Place object_1 in the drop zone
        print(f"[Task] Placing object_1 in the drop zone.")
        obs, reward, done = place(env, task, target_pos=drop_zone_loc)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()