def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided observation
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        table_pos = positions['table']
        bin_pos = positions['bin']
        switch_pos = positions['switch']

        # Step 1: Move to item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, task, obs.robot_position, item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, task, item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to the table
        print("[Task] Moving to the table at:", table_pos)
        obs, reward, done = move(env, task, obs.robot_position, table_pos)
        if done:
            print("[Task] Task ended after moving to the table!")
            return

        # Step 4: Place item1 on the table
        print("[Task] Placing item1 on the table...")
        obs, reward, done = place(env, task, item1_pos, table_pos)
        if done:
            print("[Task] Task ended after placing item1 on the table!")
            return

        # Step 5: Move to item2
        print("[Task] Moving to item2 at:", item2_pos)
        obs, reward, done = move(env, task, obs.robot_position, item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 6: Pick item2
        print("[Task] Picking item2...")
        obs, reward, done = pick(env, task, item2_pos)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 7: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 8: Place item2 in the bin
        print("[Task] Placing item2 in the bin...")
        obs, reward, done = place(env, task, item2_pos, bin_pos)
        if done:
            print("[Task] Task ended after placing item2 in the bin!")
            return

        # Step 9: Move to item3
        print("[Task] Moving to item3 at:", item3_pos)
        obs, reward, done = move(env, task, obs.robot_position, item3_pos)
        if done:
            print("[Task] Task ended after moving to item3!")
            return

        # Step 10: Pick item3
        print("[Task] Picking item3...")
        obs, reward, done = pick(env, task, item3_pos)
        if done:
            print("[Task] Task ended after picking item3!")
            return

        # Step 11: Move to the switch
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, task, obs.robot_position, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 12: Press the switch
        print("[Task] Pressing the switch...")
        obs, reward, done = press(env, task)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()