def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to pick
        rubbish_pos = positions['rubbish']  # Replace with actual object name
        robot_pos = positions['robot']  # Replace with actual robot position

        # Step 1: Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, robot_pos, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the disposal location (assuming a disposal position is known)
        disposal_pos = positions['disposal']  # Replace with actual disposal position
        print("[Task] Moving to disposal at:", disposal_pos)
        obs, reward, done = move(env, rubbish_pos, disposal_pos)
        if done:
            print("[Task] Task ended after moving to disposal!")
            return

        # Step 4: Place the rubbish down
        print("[Task] Placing down rubbish.")
        obs, reward, done = place(env, 'rubbish', disposal_pos)
        if done:
            print("[Task] Task ended after placing down rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()