def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object to pick and a location to place it
        object_pos = positions['object_1']  # Replace with actual object key
        target_pos = positions['target_location']  # Replace with actual target location key

        # Step 1: Move to the object's location
        print("[Task] Moving to object location:", object_pos)
        obs, reward, done = move(env, task, from_room='current_room', to_room='object_room')
        if done:
            print("[Task] Task ended after moving to object location!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object at:", object_pos)
        obs, reward, done = pick(env, task, obj='object_1', room='object_room', gripper='gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the target location
        print("[Task] Moving to target location:", target_pos)
        obs, reward, done = move(env, task, from_room='object_room', to_room='target_room')
        if done:
            print("[Task] Task ended after moving to target location!")
            return

        # Step 4: Place the object at the target location
        print("[Task] Placing the object at:", target_pos)
        obs, reward, done = place(env, task, obj='object_1', room='target_room')
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()