def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a specific object to manipulate
        object_name = 'item1'  # Example object name
        if object_name not in positions:
            print(f"[Task] Object '{object_name}' not found in positions.")
            return

        object_pos = positions[object_name]
        print(f"[Task] Manipulating {object_name} at:", object_pos)

        # Step 1: Move to the object's location
        obs, reward, done = move(env, task, 'current_room', 'target_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the object's location!")
            return

        # Step 2: Pick the object
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the drop location
        drop_location = 'drop_room'  # Replace with actual drop room name
        obs, reward, done = move(env, task, 'target_room', drop_location)
        if done:
            print("[Task] Task ended after moving to the drop location!")
            return

        # Step 4: Place the object
        obs, reward, done = place(env, task, object_name, drop_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()