def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'item1' in the environment
        item1_pos = positions['item1']

        # Step 1: Move to the location of item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick up item1
        print("[Task] Picking up item1...")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to the drop-off location (assuming a bin location)
        drop_off_pos = positions['bin']  # Assuming 'bin' is the drop-off location
        print("[Task] Moving to drop-off location at:", drop_off_pos)
        obs, reward, done = move(env, task, from_room=item1_pos, to_room=drop_off_pos)
        if done:
            print("[Task] Task ended after moving to drop-off location!")
            return

        # Step 4: Place item1 in the bin
        print("[Task] Placing item1 in the bin...")
        obs, reward, done = place(env, task, target_pos=drop_off_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()