def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'tomato2' is the object we need to manipulate
        tomato2_pos = positions['tomato2']
        robot_pos = positions['robot']

        # Step 1: Move to the location of 'tomato2'
        print("[Task] Moving to tomato2's location:", tomato2_pos)
        obs, reward, done = move(env, robot_pos, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2's location!")
            return

        # Step 2: Pick up 'tomato2'
        print("[Task] Picking up tomato2...")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 3: Move to a designated drop location (for example, a disposal area)
        drop_location = positions['disposal_area']
        print("[Task] Moving to drop location:", drop_location)
        obs, reward, done = move(env, tomato2_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place 'tomato2' in the drop location
        print("[Task] Placing tomato2 in the drop location...")
        obs, reward, done = place(env, task, target_pos=drop_location)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    except Exception as e:
        print(f"An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()