def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        table_pos = positions['table']
        bin_pos = positions['bin']

        # === Task Execution Plan ===
        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick up tomato1
        print("[Task] Picking up tomato1...")
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to the table
        print("[Task] Moving to the table at:", table_pos)
        obs, reward, done = move(env, task, obs.robot_position, table_pos)
        if done:
            print("[Task] Task ended after moving to the table!")
            return

        # Step 4: Place tomato1 on the table
        print("[Task] Placing tomato1 on the table...")
        obs, reward, done = place(env, task, 'tomato1', table_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 5: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick up tomato2
        print("[Task] Picking up tomato2...")
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 7: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 8: Place tomato2 in the bin
        print("[Task] Placing tomato2 in the bin...")
        obs, reward, done = place(env, task, 'tomato2', bin_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

        # Step 9: Move to rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 10: Pick up rubbish
        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, task, rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 11: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 12: Place rubbish in the bin
        print("[Task] Placing rubbish in the bin...")
        obs, reward, done = place(env, task, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()