def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Check if the target object 'rubbish' is present
        if 'rubbish' not in positions:
            print("Target object 'rubbish' not found in environment.")
            return None

        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']  # Assuming there's a bin object

        # Check the initial state of the gripper
        initial_gripper_state = getattr(obs, 'gripper_openness', -1.0)
        if initial_gripper_state > 0.1:
            print("Gripper is not closed, opening the gripper.")
            action = np.zeros(env.action_shape)
            action[-1] = 0.0  # Open the gripper
            obs, reward, done = task.step(action)
            if done:
                print("[Task] Task ended while opening the gripper!")
                return

        # Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        # Check if the rubbish is reachable
        if not is_reachable(task, rubbish_pos):
            print("Target object is not reachable.")
            return None

        # Pick the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, task, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended while picking rubbish!")
            return

        # Move to the bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended while moving to bin!")
            return

        # Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, task, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended while placing rubbish!")
            return

        print("[Task] Task completed successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()