def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'rubbish' in the environment
        rubbish_pos = positions.get('rubbish', None)
        if rubbish_pos is None:
            print("[Task] Rubbish not found in the environment.")
            return

        # Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Close the gripper to pick up the rubbish
        print("[Task] Closing gripper to pick up rubbish.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, task, obj='rubbish', room='current_room')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Move to the disposal location (assuming a location named 'disposal')
        disposal_pos = positions.get('disposal', None)
        if disposal_pos is None:
            print("[Task] Disposal location not found in the environment.")
            return

        print("[Task] Moving to disposal at:", disposal_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=disposal_pos)
        if done:
            print("[Task] Task ended after moving to disposal!")
            return

        # Place the rubbish down
        print("[Task] Placing rubbish down.")
        obs, reward, done = place(env, task, obj='rubbish', room='disposal')
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()