def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the object to pick is named 'rubbish' and is located in 'room1'
        rubbish_pos = positions['rubbish']
        room1 = 'room1'
        
        # Step 1: Move to the room where the rubbish is located
        print("[Task] Moving to room1 to pick up rubbish.")
        obs, reward, done = move(env, task, current_room, room1)
        if done:
            print("[Task] Task ended after moving to room1!")
            return
        
        # Step 2: Close the gripper to prepare for picking
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return
        
        # Step 3: Pick up the rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, 'rubbish', room1)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return
        
        # Step 4: Move to the disposal location (assuming it's 'room2')
        room2 = 'room2'
        print("[Task] Moving to room2 to dispose of rubbish.")
        obs, reward, done = move(env, task, room1, room2)
        if done:
            print("[Task] Task ended after moving to room2!")
            return
        
        # Step 5: Place the rubbish down
        print("[Task] Placing rubbish in room2.")
        obs, reward, done = place(env, task, 'rubbish', room2)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()