def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a robot and an object to manipulate
        robot_position = positions['robot']
        object_position = positions['object']  # Replace with actual object key

        # Step 1: Move to the object's location
        print("[Task] Moving to object at:", object_position)
        obs, reward, done = move(env, robot_position, object_position)
        if done:
            print("[Task] Task ended after moving to object!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object at:", object_position)
        obs, reward, done = pick(env, 'object', object_position, 'gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the disposal location (assuming a disposal location is defined)
        disposal_position = positions['disposal']  # Replace with actual disposal location key
        print("[Task] Moving to disposal location at:", disposal_position)
        obs, reward, done = move(env, object_position, disposal_position)
        if done:
            print("[Task] Task ended after moving to disposal location!")
            return

        # Step 4: Place the object in the disposal location
        print("[Task] Placing the object at disposal location:", disposal_position)
        obs, reward, done = place(env, 'object', disposal_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()