def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object and a room
        ball_pos = positions['ball']
        room_pos = positions['room']

        # Check if the room is dark
        if obs.dark:
            print("[Task] Room is dark, need to turn on the light.")
            # Move to the switch location (assuming we have a switch)
            switch_pos = positions['switch']
            obs, reward, done = move(env, task, obs.robot_position, switch_pos)
            if done:
                print("[Task] Task ended while moving to switch!")
                return
            
            # Close the gripper to press the switch
            obs, reward, done = close_gripper(env, task)
            if done:
                print("[Task] Task ended while closing gripper!")
                return
            
            # Press the switch to turn on the light
            obs, reward, done = press(env, task, switch_pos)
            if done:
                print("[Task] Task ended while pressing the switch!")
                return

        # Now the room should be lit, we can pick the ball
        obs, reward, done = pick(env, task, ball_pos)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Move to the drop location (assuming we have a drop zone)
        drop_zone_pos = positions['drop_zone']
        obs, reward, done = move(env, task, obs.robot_position, drop_zone_pos)
        if done:
            print("[Task] Task ended while moving to drop zone!")
            return

        # Place the ball in the drop zone
        obs, reward, done = place(env, task, ball_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()