(define (domain robot-disposal)

  (:requirements :strips :typing)

  (:types

    object

    location

    switchtype

  )

  (:predicates

    (at ?obj - object ?loc - location)

    (holding ?obj - object)

    (handempty)

    (dark)

    (gripper_closed)

  )

  (:action pick

    :parameters (?obj - object ?loc - location)

    :precondition (and

      (at ?obj ?loc)

      (handempty)

      (not (dark))

    )

    :effect (and

      (holding ?obj)

      (not (handempty))

      (not (at ?obj ?loc))

    )

  )

  (:action place

    :parameters (?obj - object ?loc - location)

    :precondition (and

      (holding ?obj)

      (not (dark))

    )

    :effect (and

      (at ?obj ?loc)

      (handempty)

      (not (holding ?obj))

    )

  )

  (:action close_gripper

    :parameters ()

    :precondition (not (gripper_closed))

    :effect (gripper_closed)

  )

  (:action press

    :parameters (?sw - switchtype)

    :precondition (and (gripper_closed) (dark))

    :effect (not (dark))

  )

)
