import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        item1_pos = positions['item1']
        tomato2_pos = positions['tomato2']
        item2_pos = positions['item2']
        bin_pos = positions['bin']
        switch_pos = positions['switch']

        # === Task Plan Execution ===
        # Step 1: Pick item1
        print("[Task] Picking item1 at:", item1_pos)
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 2: Place item1 in the bin
        print("[Task] Placing item1 in the bin at:", bin_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

        # Step 3: Pick tomato2
        print("[Task] Picking tomato2 at:", tomato2_pos)
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 4: Place tomato2 in the bin
        print("[Task] Placing tomato2 in the bin at:", bin_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

        # Step 5: Press the switch to turn on the light
        print("[Task] Pressing the switch at:", switch_pos)
        obs, reward, done = press(env, task, target_pos=switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()