def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a 'rubbish' object to pick and a 'room' to place it in
        rubbish_pos = positions['rubbish']  # Replace with actual object name
        room_pos = positions['room']  # Replace with actual room name

        # Step 1: Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Close the gripper
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 3: Pick the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, task, obj='rubbish', room='room', gripper='gripper')
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        # Step 4: Move to the room
        print("[Task] Moving to room at:", room_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=room_pos)
        if done:
            print("[Task] Task ended after moving to room!")
            return

        # Step 5: Place the rubbish
        print("[Task] Placing rubbish in the room.")
        obs, reward, done = place(env, task, obj='rubbish', room='room')
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()