def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named as follows based on the provided PDDL
        ball_pos = positions['ball']
        bin_pos = positions['bin']
        switch_pos = positions['switch']
        robot_pos = positions['robot']

        # Step 1: Move to the ball
        print("[Task] Moving to the ball at:", ball_pos)
        obs, reward, done = move(env, robot_pos, ball_pos)
        if done:
            print("[Task] Task ended after moving to the ball!")
            return

        # Step 2: Pick the ball
        print("[Task] Picking the ball.")
        obs, reward, done = pick(env, 'ball', ball_pos)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 3: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, ball_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 4: Place the ball in the bin
        print("[Task] Placing the ball in the bin.")
        obs, reward, done = place(env, 'ball', bin_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

        # Step 5: Move to the switch
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, bin_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 6: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()