import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        top_pos = positions['top_anchor_pos']
        middle_pos = positions['middle_anchor_pos']
        bottom_pos = positions['bottom_anchor_pos']
        bin_pos = positions['bin']
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']

        # === Task Execution Plan ===
        # Step 1: Pull open any unlocked drawer
        try:
            if not obs.is_locked(top_pos):
                obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
                if done:
                    print("[Task] Drawer opened successfully!")
            elif not obs.is_locked(middle_pos):
                obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
                if done:
                    print("[Task] Drawer opened successfully!")
            elif not obs.is_locked(bottom_pos):
                obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
                if done:
                    print("[Task] Drawer opened successfully!")
            else:
                print("[Task] All drawers are locked, cannot proceed.")
                return
        except Exception as e:
            print(f"[Task] Error while pulling drawer: {e}")
            return

        # Step 2: Place the rubbish into the bin
        try:
            obs, reward, done = place(env, task, target_pos=bin_pos)
            if done:
                print("[Task] Rubbish placed into the bin successfully!")
            else:
                print("[Task] Failed to place rubbish into the bin.")
        except Exception as e:
            print(f"[Task] Error while placing rubbish: {e}")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()