def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (replace with actual object names)
        tomato_pos = positions['tomato']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['drawer']

        # Step 1: Move to the tomato
        print("[Task] Moving to the tomato at:", tomato_pos)
        obs, reward, done = move(env, 'room_a', tomato_pos)
        if done:
            print("[Task] Task ended after moving to the tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, 'tomato', 'room_a', 'gripper')
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, 'room_a', bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 4: Place the tomato in the bin
        print("[Task] Placing the tomato in the bin.")
        obs, reward, done = place(env, 'tomato', 'bin')
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

        # Step 5: Move to the rubbish
        print("[Task] Moving to the rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'room_a', rubbish_pos)
        if done:
            print("[Task] Task ended after moving to the rubbish!")
            return

        # Step 6: Pick the rubbish
        print("[Task] Picking the rubbish.")
        obs, reward, done = pick(env, 'rubbish', 'room_a', 'gripper')
        if done:
            print("[Task] Task ended after picking the rubbish!")
            return

        # Step 7: Move to the bin again
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, 'room_a', bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 8: Place the rubbish in the bin
        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', 'bin')
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()