def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the rubbish and trash can are identified in the positions
        rubbish_pos = positions['rubbish']
        trash_can_pos = positions['trash_can']
        gripper = 'gripper'  # Assuming a single gripper is used

        # Step 1: Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, gripper)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the trash can
        print("[Task] Moving to trash can at:", trash_can_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], trash_can_pos)
        if done:
            print("[Task] Task ended after moving to trash can!")
            return

        # Step 4: Place the rubbish in the trash can
        print("[Task] Placing rubbish in trash can...")
        obs, reward, done = place(env, task, trash_can_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()