def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'object_1', 'object_2', etc.
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']
        drawer_pos = positions['drawer']

        # === Example Task Plan ===
        # 1) Move to the drawer to pick it
        print("[Task] Moving to the drawer...")
        obs, reward, done = move(env, 'initial_room', drawer_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # 2) Pick the drawer
        print("[Task] Picking the drawer...")
        obs, reward, done = pick(env, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended while picking the drawer!")
            return

        # 3) Move to the object to pick it
        print("[Task] Moving to object 1...")
        obs, reward, done = move(env, drawer_pos, object_1_pos)
        if done:
            print("[Task] Task ended while moving to object 1!")
            return

        # 4) Pick the object
        print("[Task] Picking object 1...")
        obs, reward, done = pick(env, 'object_1', object_1_pos)
        if done:
            print("[Task] Task ended while picking object 1!")
            return

        # 5) Move to place the object
        print("[Task] Moving to place object 1...")
        obs, reward, done = move(env, object_1_pos, 'target_location')
        if done:
            print("[Task] Task ended while moving to place object 1!")
            return

        # 6) Place the object
        print("[Task] Placing object 1...")
        obs, reward, done = place(env, 'object_1', 'target_location')
        if done:
            print("[Task] Task ended while placing object 1!")
            return

        print("[Task] Completed all actions successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()