def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        object_1 = 'object_1'    # Placeholder for the object to pick
        object_2 = 'object_2'    # Placeholder for the object to place

        # Example Task Plan
        # 1) Move to the location of object_1
        print("[Task] Moving to the location of object_1.")
        obs, reward, done = move(env, 'initial_location', positions[object_1])
        if done:
            print("[Task] Task ended after moving to object_1 location!")
            return

        # 2) Pick object_1
        print("[Task] Picking object_1.")
        obs, reward, done = pick(env, object_1, positions[object_1], gripper)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # 3) Move to the drawer location
        print("[Task] Moving to the drawer location.")
        obs, reward, done = move(env, positions[object_1], positions[drawer])
        if done:
            print("[Task] Task ended after moving to drawer location!")
            return

        # 4) Place object_1 in the drawer
        print("[Task] Placing object_1 in the drawer.")
        obs, reward, done = place(env, object_1, positions[drawer])
        if done:
            print("[Task] Task ended after placing object_1 in the drawer!")
            return

        # 5) Move back to the initial location
        print("[Task] Moving back to the initial location.")
        obs, reward, done = move(env, positions[drawer], 'initial_location')
        if done:
            print("[Task] Task ended after returning to initial location!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()