def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        rubbish_pos = positions['rubbish']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        bin_pos = positions['bin']

        # Step 1: Move to the position of rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 4: Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after placing rubbish in the bin!")
            return

        # Step 5: Move to the position of tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 6: Pick up tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 7: Move to the position of tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 8: Pick up tomato2
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', tomato2_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 9: Move back to the bin
        print("[Task] Moving back to bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving back to bin!")
            return

        # Step 10: Place tomato1 in the bin
        print("[Task] Placing tomato1 in the bin.")
        obs, reward, done = place(env, 'tomato1', bin_pos)
        if done:
            print("[Task] Task ended after placing tomato1 in the bin!")
            return

        # Step 11: Place tomato2 in the bin
        print("[Task] Placing tomato2 in the bin.")
        obs, reward, done = place(env, 'tomato2', bin_pos)
        if done:
            print("[Task] Task ended after placing tomato2 in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()