def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved positions
        rubbish_pos = positions['rubbish']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        bin_pos = positions['bin']

        # Step 1: Move to the first tomato
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, 'room', tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick up the first tomato
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'room', 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, 'room', bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 4: Place the first tomato in the bin
        print("[Task] Placing tomato1 in the bin.")
        obs, reward, done = place(env, 'tomato1', 'bin')
        if done:
            print("[Task] Task ended after placing tomato1 in the bin!")
            return

        # Step 5: Move to the second tomato
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, 'room', tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick up the second tomato
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'room', 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 7: Move to the bin again
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, 'room', bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 8: Place the second tomato in the bin
        print("[Task] Placing tomato2 in the bin.")
        obs, reward, done = place(env, 'tomato2', 'bin')
        if done:
            print("[Task] Task ended after placing tomato2 in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()