def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        drawer = 'drawer1'
        gripper = 'gripper1'
        object1 = 'object1'  # The object to pick
        object2 = 'object2'  # The object to place
        initial_position = positions[object1]  # Get the position of the object to pick
        target_position = positions[object2]  # Get the position of the target location

        # Step 1: Move to the initial position of the object
        print("[Task] Moving to the initial position of the object.")
        move(env, 'room1', 'room2')  # Example move, replace with actual room names

        # Step 2: Pick the object
        print("[Task] Picking the object.")
        pick(env, object1, 'room2', gripper)

        # Step 3: Move to the target position
        print("[Task] Moving to the target position.")
        move(env, 'room2', 'room3')  # Example move, replace with actual room names

        # Step 4: Place the object
        print("[Task] Placing the object.")
        place(env, object1, 'room3')

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()