def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        object_to_pick = 'rubbish'  # Placeholder for the object to pick

        # Get the initial positions of the gripper and the drawer
        gripper_pos = positions[gripper]
        drawer_pos = positions[drawer]
        object_pos = positions[object_to_pick]

        # Step 1: Move to the object's position
        print(f"[Task] Moving to the position of {object_to_pick} at:", object_pos)
        obs, reward, done = move(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after moving to the object position!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking up {object_to_pick}.")
        obs, reward, done = pick(env, object_to_pick, object_pos, gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the drawer's position
        print(f"[Task] Moving to the position of the drawer at:", drawer_pos)
        obs, reward, done = move(env, task, target_pos=drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer position!")
            return

        # Step 4: Place the object in the drawer
        print(f"[Task] Placing {object_to_pick} in the drawer.")
        obs, reward, done = place(env, object_to_pick, drawer_pos)
        if done:
            print("[Task] Task ended after placing the object in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()