def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects based on the PDDL and initial state
        drawer1_pos = positions['drawer1']
        robot_pos = positions['robot']
        object1_pos = positions['object1']  # Example object

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer1_pos)
        move(env, robot_pos, drawer1_pos)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        pick(env, 'drawer1', drawer1_pos, 'gripper')

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer")
        pull(env, 'gripper', 'drawer1')

        # Step 4: Move to the object
        print("[Task] Moving to the object at:", object1_pos)
        move(env, drawer1_pos, object1_pos)

        # Step 5: Pick the object
        print("[Task] Picking the object")
        pick(env, 'object1', object1_pos, 'gripper')

        # Step 6: Place the object back in the drawer
        print("[Task] Placing the object back in the drawer")
        place(env, 'object1', drawer1_pos)

        # Step 7: Close the drawer (if needed)
        print("[Task] Closing the drawer")
        # Assuming we have a close action, if not, we can skip this step

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()