def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper_1'  # Example gripper name
        drawer = 'drawer_1'     # Example drawer name
        object_to_pick = 'object_1'  # Example object to pick
        initial_position = positions[object_to_pick]  # Get the initial position of the object

        # Step 1: Move to the object's position
        print(f"[Task] Moving to the position of {object_to_pick} at: {initial_position}")
        obs, reward, done = move(env, 'room_a', initial_position)
        if done:
            print("[Task] Task ended after moving to the object's position!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking up {object_to_pick}")
        obs, reward, done = pick(env, object_to_pick, 'room_a', gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the drawer's position
        drawer_position = positions[drawer]  # Get the position of the drawer
        print(f"[Task] Moving to the position of {drawer} at: {drawer_position}")
        obs, reward, done = move(env, 'room_a', drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer's position!")
            return

        # Step 4: Place the object in the drawer
        print(f"[Task] Placing {object_to_pick} in {drawer}")
        obs, reward, done = place(env, object_to_pick, drawer_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()