def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        initial_position = 'room_a'  # Placeholder for the initial position of the robot

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        move(env, initial_position, initial_position)

        # Step 2: Rotate the gripper to the required angle
        print("[Task] Rotating gripper to ninety degrees")
        rotate(env, gripper, 'zero_deg', 'ninety_deg')

        # Step 3: Pick the drawer
        print("[Task] Picking the drawer")
        pick_door(env, gripper, drawer, 'anchor_position')  # Assuming 'anchor_position' is defined

        # Step 4: Pull the drawer
        print("[Task] Pulling the drawer")
        pull(env, gripper, drawer)

        # Step 5: Place the object (if any) in the drawer
        print("[Task] Placing object in the drawer")
        place(env, 'object_1', 'drawer_position')  # Assuming 'drawer_position' is defined

        # Complete the task
        print("[Task] Task completed successfully!")

    except Exception as e:
        print("[Error] An error occurred:", str(e))
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()