import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *  
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()

        init_video_writers(obs)

        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        positions = get_object_positions()

        rubbish_pos = positions['item3']  
        bin_pos = positions['bin']

        # Step 1: Pull open any drawer that is not locked
        for drawer in ['bottom', 'middle', 'top']:
            print(f"[Task] Attempting to pull the {drawer} drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y', max_steps=100, threshold=0.01, timeout=10.0)
            if done:
                print(f"[Task] {drawer.capitalize()} drawer pulled successfully!")
                break
        else:
            print("[Task] All drawers are locked or could not be pulled.")

        # Step 2: Drop the rubbish into the bin
        print("[Task] Placing rubbish into the bin.")
        obs, reward, done = place(env, task, target_pos=bin_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done:
            print("[Task] Rubbish placed successfully into the bin!")
        else:
            print("[Task] Failed to place rubbish into the bin.")

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()