import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        _, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        item1_pos = positions['item1']  # Assuming item1 is rubbish
        bin_pos = positions['bin']

        # === Execute the Plan ===
        # Step 1: Pull open any available drawer
        if not obs.is_open['top']:  # Check if the top drawer is locked
            print("[Task] Pulling the top drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
            if done:
                print("[Task] Task ended after pulling the top drawer!")
                return

        elif not obs.is_open['middle']:  # Check if the middle drawer is locked
            print("[Task] Pulling the middle drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
            if done:
                print("[Task] Task ended after pulling the middle drawer!")
                return

        elif not obs.is_open['bottom']:  # Check if the bottom drawer is locked
            print("[Task] Pulling the bottom drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
            if done:
                print("[Task] Task ended after pulling the bottom drawer!")
                return

        # Step 2: Pick up any rubbish remaining on the table
        print("[Task] Picking up rubbish from the table.")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")