def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']
        gripper = 'gripper'  # Assuming a gripper object is available

        # Step 1: Move to item1 position
        print("[Task] Moving to item1 position:", item1_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to bottom anchor position
        print("[Task] Moving to bottom anchor position:", bottom_anchor_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], bottom_anchor_pos)
        if done:
            print("[Task] Task ended after moving to bottom anchor!")
            return

        # Step 4: Place item1 at bottom anchor
        print("[Task] Placing item1 at bottom anchor...")
        obs, reward, done = place(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

        # Step 5: Move to item2 position
        print("[Task] Moving to item2 position:", item2_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 6: Pick item2
        print("[Task] Picking item2...")
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 7: Move to middle anchor position
        print("[Task] Moving to middle anchor position:", middle_anchor_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], middle_anchor_pos)
        if done:
            print("[Task] Task ended after moving to middle anchor!")
            return

        # Step 8: Place item2 at middle anchor
        print("[Task] Placing item2 at middle anchor...")
        obs, reward, done = place(env, task, target_pos=middle_anchor_pos)
        if done:
            print("[Task] Task ended after placing item2!")
            return

        # Step 9: Move to item3 position
        print("[Task] Moving to item3 position:", item3_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], item3_pos)
        if done:
            print("[Task] Task ended after moving to item3!")
            return

        # Step 10: Pick item3
        print("[Task] Picking item3...")
        obs, reward, done = pick(env, task, target_pos=item3_pos)
        if done:
            print("[Task] Task ended after picking item3!")
            return

        # Step 11: Move to top anchor position
        print("[Task] Moving to top anchor position:", top_anchor_pos)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], top_anchor_pos)
        if done:
            print("[Task] Task ended after moving to top anchor!")
            return

        # Step 12: Place item3 at top anchor
        print("[Task] Placing item3 at top anchor...")
        obs, reward, done = place(env, task, target_pos=top_anchor_pos)
        if done:
            print("[Task] Task ended after placing item3!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()