def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        initial_position = 'initial_position'  # Placeholder for the robot's initial position
        side_position = 'side_position'        # Placeholder for the side position of the drawer
        anchor_position = 'anchor_position'    # Placeholder for the anchor position of the drawer

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position.")
        obs, reward, done = move(env, initial_position, side_position)
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Step 2: Rotate the gripper to the correct angle
        print("[Task] Rotating gripper to the correct angle.")
        target_angle = 'ninety_deg'  # Placeholder for the target angle
        obs, reward, done = rotate(env, task, target_angle)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 3: Move to the side position of the drawer
        print("[Task] Moving to the side position of the drawer.")
        obs, reward, done = move(env, side_position, anchor_position)
        if done:
            print("[Task] Task ended after moving to the side position!")
            return

        # Step 4: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, anchor_position, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 6: Place the drawer back
        print("[Task] Placing the drawer back.")
        obs, reward, done = place(env, drawer, anchor_position)
        if done:
            print("[Task] Task ended after placing the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()