def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a "bin" object to interact with
        bin_pos = positions['bin']  # Ensure 'bin' is in the object list
        robot_pos = positions['robot']  # Robot's initial position

        # Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, robot_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Pick up the object (assuming we are picking something from the bin)
        print("[Task] Picking up the object from the bin.")
        obs, reward, done = pick(env, 'object', bin_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to a designated drop-off location (assuming we have a drop-off position)
        drop_off_pos = positions['drop_off']  # Ensure 'drop_off' is in the object list
        print("[Task] Moving to the drop-off location at:", drop_off_pos)
        obs, reward, done = move(env, bin_pos, drop_off_pos)
        if done:
            print("[Task] Task ended after moving to the drop-off location!")
            return

        # Place the object at the drop-off location
        print("[Task] Placing the object at the drop-off location.")
        obs, reward, done = place(env, 'object', drop_off_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()