import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *  # Importing predefined skills
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        bottom_drawer_pos = positions['bottom_anchor_pos']
        middle_drawer_pos = positions['middle_anchor_pos']
        top_drawer_pos = positions['top_anchor_pos']
        bin_pos = positions['bin']
        
        # === Execute the Plan ===
        # Step 1: Pull open any drawer that is not locked
        try:
            # Attempt to pull the bottom drawer first
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y', max_steps=100, threshold=0.01, timeout=10.0)
            if done:
                print("[Task] Drawer pulled successfully!")
            else:
                print("[Task] Failed to pull the drawer.")
        except Exception as e:
            print(f"[Task] Error during pulling: {e}")

        # Step 2: Drop the rubbish into the bin
        try:
            obs, reward, done = place(env, task, target_pos=bin_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
            if done:
                print("[Task] Rubbish placed in the bin successfully!")
            else:
                print("[Task] Failed to place the rubbish in the bin.")
        except Exception as e:
            print(f"[Task] Error during placing: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()