def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer and a gripper
        drawer_position = positions['drawer']
        gripper_position = positions['gripper']
        object_position = positions['object']  # Replace with actual object name

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_position)
        move(env, gripper_position, drawer_position)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        pick(env, 'drawer', drawer_position, 'gripper')

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer")
        pull(env, 'gripper', 'drawer')

        # Step 4: Move to the object
        print("[Task] Moving to the object at:", object_position)
        move(env, drawer_position, object_position)

        # Step 5: Pick the object
        print("[Task] Picking the object")
        pick(env, 'object', object_position, 'gripper')

        # Step 6: Place the object back in the drawer
        print("[Task] Placing the object back in the drawer")
        place(env, 'object', drawer_position)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()