def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer and a gripper
        drawer_position = positions['drawer']
        gripper_position = positions['gripper']
        object_position = positions['object']  # Replace with actual object name

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_position)
        obs, reward, done = move(env, task, gripper_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer', drawer_position, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1)  # Adjust pull distance as needed
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Move to the object
        print("[Task] Moving to the object at:", object_position)
        obs, reward, done = move(env, task, drawer_position, object_position)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 5: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object', object_position, 'gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 6: Place the object
        print("[Task] Placing the object.")
        obs, reward, done = place(env, 'object', drawer_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()