def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are 'tomato1', 'tomato2', 'rubbish', 'plate'
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        plate_pos = positions['plate']

        # Example Task Plan
        # 1) Pick up tomato1
        print("[Task] Picking up tomato1 at:", tomato1_pos)
        obs, reward, done = pick(env, task, 'tomato1', tomato1_pos)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # 2) Place tomato1 on the plate
        print("[Task] Placing tomato1 on plate at:", plate_pos)
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # 3) Pick up rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # 4) Place rubbish in a designated area (assuming a specific position for disposal)
        disposal_pos = positions['disposal_area']  # Assuming this position is defined
        print("[Task] Placing rubbish in disposal area at:", disposal_pos)
        obs, reward, done = place(env, task, disposal_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()