def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        tomato_pos = positions['tomato']
        drawer_pos = positions['drawer']
        gripper = 'gripper'  # Assuming a single gripper is used

        # Step 1: Move to the drawer position
        print("[Task] Moving to the drawer position.")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Open the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, gripper, 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 3: Move to the tomato position
        print("[Task] Moving to the tomato position.")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], tomato_pos)
        if done:
            print("[Task] Task ended after moving to the tomato!")
            return

        # Step 4: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, 'tomato', tomato_pos, gripper)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 5: Move back to the drawer
        print("[Task] Moving back to the drawer position.")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], drawer_pos)
        if done:
            print("[Task] Task ended after moving back to the drawer!")
            return

        # Step 6: Place the tomato in the drawer
        print("[Task] Placing the tomato in the drawer.")
        obs, reward, done = place(env, task, drawer_pos, approach_distance=0.15)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()