def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'    # Placeholder for the actual drawer object
        initial_position = positions['initial_position']  # Placeholder for the robot's initial position
        target_position = positions['target_position']    # Placeholder for the target position

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        obs, reward, done = move(env, initial_position, target_position)
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Step 2: Rotate the gripper to the desired angle
        target_quat = [0, 0, 0, 1]  # Placeholder for the target quaternion
        print("[Task] Rotating gripper to target orientation.")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 3: Pick an object
        object_to_pick = 'object_1'  # Placeholder for the actual object to pick
        print("[Task] Picking object:", object_to_pick)
        obs, reward, done = pick(env, object_to_pick, target_position, gripper)
        if done:
            print("[Task] Task ended after picking object!")
            return

        # Step 4: Place the object in the drawer
        print("[Task] Placing object in drawer:", drawer)
        obs, reward, done = place(env, object_to_pick, drawer)
        if done:
            print("[Task] Task ended after placing object in drawer!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer:", drawer)
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()