def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        object_1 = 'object_1' # Placeholder for the first object
        object_2 = 'object_2' # Placeholder for the second object

        # Example Task Plan
        # 1) Move to the location of the first object
        print("[Task] Moving to the location of the first object.")
        obs, reward, done = move(env, 'initial_location', positions[object_1])
        if done:
            print("[Task] Task ended after moving to the first object!")
            return

        # 2) Pick the first object
        print("[Task] Picking the first object.")
        obs, reward, done = pick(env, object_1, positions[object_1], gripper)
        if done:
            print("[Task] Task ended after picking the first object!")
            return

        # 3) Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, positions[object_1], positions[drawer])
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # 4) Place the first object in the drawer
        print("[Task] Placing the first object in the drawer.")
        obs, reward, done = place(env, task, positions[drawer])
        if done:
            print("[Task] Task ended after placing the first object!")
            return

        # 5) Move to the location of the second object
        print("[Task] Moving to the location of the second object.")
        obs, reward, done = move(env, positions[drawer], positions[object_2])
        if done:
            print("[Task] Task ended after moving to the second object!")
            return

        # 6) Pick the second object
        print("[Task] Picking the second object.")
        obs, reward, done = pick(env, object_2, positions[object_2], gripper)
        if done:
            print("[Task] Task ended after picking the second object!")
            return

        # 7) Move back to the drawer
        print("[Task] Moving back to the drawer.")
        obs, reward, done = move(env, positions[object_2], positions[drawer])
        if done:
            print("[Task] Task ended after moving back to the drawer!")
            return

        # 8) Place the second object in the drawer
        print("[Task] Placing the second object in the drawer.")
        obs, reward, done = place(env, task, positions[drawer])
        if done:
            print("[Task] Task ended after placing the second object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()